/*---------------------------------------------------------------------------*\

    FILE....: LOWSAM.CPP
    TYPE....: C++ program
    AUTHOR..: David Rowe
    DATE....: 13/2/01

    Test program for sampling audio from V4PCI, used low level config, rather
    the vpb api functions.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include "../src/mess.h"
#include "../src/comm.h"
#include "../src/config.h"
#include "../src/dspfifo.h"
#include "../src/timer.h"
#include "../src/timer.h"
#include "../src/wobbly.h"
#include "../src/wavecpp.h"
#include "../src/vpbapi.h"
#include "../src/mapdev.h"
#include "../src/translate.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

int kbhit();

#define WAIT		1	// time out delay 
#define	BOARD		0	// board number
#define	N	        160	// size of processing frame
#define LOG_FRAMES      200     // number of frames to log

word offhook[] = {
	PC_LCODEC_OFFHK,
	PC_CODEC_OFFHK,
	0			// channel
};

word onhook[] = {
	PC_LCODEC_ONHK,
	PC_CODEC_ONHK,
	0			// channel
};

void set_codec_reg(int    chdev,
	           unsigned short addr, 
          	   unsigned short data,  
		   Comm   *c
		  );
void record_set_hw_gain(int handle, float gain, Comm *c);

int main(int argc, char *argv[])
{
	long		i;
	VPBREG		*v;
	word		upmess[COMM_MAX_MESS];
	char		s[MAX_STR];
	void		*win;
	int		ch1_offhook;
	short		buf[N];
	int		frames;

	if (argc != 2) {
		printf("usage: %s InputFile(D/A)\n",argv[0]);
		exit(0);
	}

	wave_open_write(&win, argv[1], VPB_LINEAR);

	// initialise 

	try {
		mess_mprintf_on();

		Comm comm;
		v = comm.vpbreg(BOARD);

		// configure VPB signal processing --------------------------

		config_create_object(&comm, BOARD, CODEC_AD , 0, 0, 0);
		config_create_object(&comm, BOARD, ALAW2LIN , 1, 0, 0);
		config_create_object(&comm, BOARD, LIN2ALAW , 2, 0, 0);
		config_create_object(&comm, BOARD, CODEC_DA , 3, 2, 0);

		config_create_object(&comm, BOARD, FIFO_UP  , 4, 0, 
				     v->szrxdf[0]);

		config_create_wire(&comm, BOARD, 0, 1);
		config_create_wire(&comm, BOARD, 1, 2);
		config_create_wire(&comm, BOARD, 2, 3);
      		config_create_wire(&comm, BOARD, 1, 4);

		onhook[2] = 0;
		comm.PutMessageVPB(BOARD,onhook);
		ch1_offhook = 1;

		// set codec diff amp (V4PCI only)
		set_codec_reg(0, 0x32, 0xd3, &comm);
		// set codec gain
		record_set_hw_gain(0, 6.0, &comm);

		printf("codec reg set...\n");

		// start main processing loop ------------------------------
		
		config_run(&comm, BOARD);
		i = 0;
		frames = 0;
		do {
			// check for events from VPB

			while(comm.GetMessageVPB(BOARD, upmess) == OK) {
				translate(BOARD, s, upmess);
				mprintf(s);
				if (upmess[1] == DSP_CODEC_RING) {
					offhook[2] = upmess[2];
					comm.PutMessageVPB(BOARD,offhook);
					if (upmess[2] ==0)
						ch1_offhook = 1;
				}
			}

			if (ch1_offhook) {

				while(v->rxdf[0]->Read((word*)buf, N) != OK)
					comm.CheckForAssert(BOARD);
				vpb_wave_write(win, (char*)buf, sizeof(buf));
				//printf("\rframes: %d",frames++);
				frames++;
				if (frames == LOG_FRAMES-20) {
					onhook[2] = 0;
					comm.PutMessageVPB(BOARD,onhook);
				}
			}

		} while(frames < LOG_FRAMES);

		// send clear config message -------------------------------

		config_stop(&comm, BOARD);
		config_clear(&comm, BOARD);

		vpb_wave_close_write(win);

	}	// try ...

	catch (Wobbly w) {
		char	s[MAX_STR];
		
		w.translate(s);
		
		if (w.file[0] != 0) 
			printf("exception caught: %s, %s, line = %d\n",s, 
			       w.file, w.line);
		else
			printf("exception caught: %s\n",s);

		printf("Press any key to exit....\n");
	}
}

